Imports multiple_signatures.DynaPDF

Module Module1

   ' Error callback function.
   ' If the function name should not appear at the beginning of the error message then set
   ' the flag emNoFuncNames (pdf.SetErrorMode(CPDF.TErrMode.emNoFuncNames)).
   Private Function PDFError(ByVal Data As IntPtr, ByVal ErrCode As Integer, ByVal ErrMessage As IntPtr, ByVal ErrType As Integer) As Integer
      Console.WriteLine("{0}", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage))
      Return 0 ' We try to continue if an error occurrs. Any other return value breaks processing.
   End Function

   Function SignFile(PDF As CPDF, InFileName As String, OutFileName As String, FieldName As String, Reason As String, PosX As double, VisibleSignature As Boolean) As Boolean
      dim retval As Boolean
      dim filePath As String = Nothing
      dim outName As String = OutFileName
      if InFileName = OutFileName then
         filePath = System.IO.Path.GetTempFileName()
         outName  = filePath
      End if
      PDF.CreateNewPDF(outName)

      ' Adding multiple signatures with a demo version of DynaPDF couldn't work since a demo string would
      ' be added to each page that was edited or changed and this would invalidate previous signatures.
      pdf.SetLicenseKey("SigDemo")

      ' This flag also sets the flags ifImportAsPage Or ifImportAll, and if2UseProxy Or if2CopyEncryptDict to make sure that
      ' anything is imported and nothing gets changed.
      PDF.SetImportFlags2(TImportFlags2.if2IncrementalUpd)
      if PDF.OpenImportFile(InFileName, TPwdType.ptOpen, Nothing) < 0 then return false
      PDF.ImportPDFFile(1, 1.0, 1.0)

      if VisibleSignature then
         PDF.SetPageCoords(TPageCoord.pcTopDown)
         PDF.EditPage(1)
            dim sig As Integer = PDF.CreateSigField(FieldName, -1, PosX, 30.0, 180.0, 40.0)
            PDF.SetFieldBorderWidth(sig, 0.0)
         PDF.EndPage()
      End if
      retval = PDF.CloseAndSignFile("../../../../test_files/test_cert.pfx", "123456", Reason, Nothing) 
      if retval then
         if outName = filePath then
            System.IO.File.Delete(OutFileName)
            System.IO.File.Move(outName, OutFileName)
         End if
      End if
      return retval
   End Function

   Sub Main()
      Try
         Dim pdf As CPDF = New CPDF()
         ' You can either use events or declare a callback function.
         pdf.SetOnErrorProc(AddressOf PDFError)

         ' We write the output file into the current directory.
         dim filePath As String = System.IO.Directory.GetCurrentDirectory() + "\\out.pdf"

         ' We sign the file 4 times in this example. We add two visible and two invisible signatures.
         if SignFile(pdf, "../../../../../license.PDF", filePath, "Signature1", "Test signature 1", 50.0, true) then
            if SignFile(pdf, filePath, filePath, "Signature2", "Test signature 2", 430.0, true) then
               if SignFile(pdf, filePath, filePath, Nothing, "Test signature 3", 0.0, false) then
                  if SignFile(pdf, filePath, filePath, Nothing, "Test signature 4", 0.0, false) then
                     Console.Write("PDF file ""{0}"" successfully created!" + Chr(10), filePath)
                     Dim p As System.Diagnostics.Process = New System.Diagnostics.Process()
                     p.StartInfo.FileName = filePath
                     p.Start()
                  End if
               End if
            End if
         End if
      Catch e As Exception
         Console.Write(e.Message + Chr(10))
         Console.Read()
      End Try
   End Sub

End Module
